<?php
// Page configuration
$page_title = "About Us";
$page_description = "Learn about Shree Shyam Vartika - Your trusted event management partner since 2015. Meet our team, discover our story, and see why we're the preferred choice for memorable celebrations.";
$body_class = "about-page";

// Include database connection
require_once '../config/db.php';

// Include header
include '../includes/header.php';
?>

<!-- About Hero Section -->
<section class="section" style="background: var(--bg-gradient); color: white; padding-top: 8rem;">
    <div class="container">
        <div class="grid grid-2" style="align-items: center; gap: 4rem;">
            <div class="animate-fade-left">
                <h1 class="section-title" style="color: white; font-size: 3rem;">About Shree Shyam Vartika</h1>
                <p class="section-subtitle script-text" style="color: var(--light-gold); font-size: 1.5rem;">Creating Magical Moments Since 2015</p>
                <p style="font-size: 1.2rem; line-height: 1.8; margin-bottom: 2rem; color: rgba(255,255,255,0.9);">
                    We are passionate about turning your dreams into reality. With over 8 years of experience in event management, 
                    we have successfully organized more than 500 weddings, engagements, birthdays, and corporate events.
                </p>
                <div class="hero-stats" style="display: flex; gap: 2rem; margin-bottom: 2rem;">
                    <div class="stat-item">
                        <div style="font-size: 2rem; font-weight: bold; color: var(--accent-gold);">500+</div>
                        <div style="font-size: 0.9rem;">Events Organized</div>
                    </div>
                    <div class="stat-item">
                        <div style="font-size: 2rem; font-weight: bold; color: var(--accent-gold);">8+</div>
                        <div style="font-size: 0.9rem;">Years Experience</div>
                    </div>
                    <div class="stat-item">
                        <div style="font-size: 2rem; font-weight: bold; color: var(--accent-gold);">4.9★</div>
                        <div style="font-size: 0.9rem;">Client Rating</div>
                    </div>
                </div>
            </div>
            
            <div class="animate-fade-right">
                <img src="assets/images/about-team.jpg" alt="Our professional event management team" 
                     data-src="assets/images/about-team.jpg" 
                     class="lazy" 
                     style="width: 100%; border-radius: 16px; box-shadow: 0 20px 40px rgba(0,0,0,0.3);">
            </div>
        </div>
    </div>
</section>

<!-- Our Story Section -->
<section class="section">
    <div class="container">
        <div class="grid grid-2" style="align-items: center; gap: 4rem;">
            <div class="animate-fade-left">
                <img src="assets/images/our-story.jpg" alt="Our journey in event management" 
                     data-src="assets/images/our-story.jpg" 
                     class="lazy" 
                     style="width: 100%; border-radius: 16px; box-shadow: var(--shadow-lg);">
            </div>
            
            <div class="animate-fade-right">
                <div class="section-header">
                    <p class="section-subtitle script-text">Our Journey</p>
                    <h2 class="section-title">How It All Started</h2>
                </div>
                <p style="margin-bottom: 1.5rem; line-height: 1.8; color: var(--text-secondary);">
                    <strong>Shree Shyam Vartika</strong> was born from a simple belief: every celebration deserves to be extraordinary. 
                    Founded in 2015, we started as a small team with big dreams and an unwavering commitment to excellence.
                </p>
                <p style="margin-bottom: 1.5rem; line-height: 1.8; color: var(--text-secondary);">
                    Our journey began when our founder, inspired by the joy of bringing families together, decided to turn 
                    a passion for event planning into a professional service. What started with organizing small family 
                    gatherings has now grown into one of the most trusted event management companies in the region.
                </p>
                <p style="margin-bottom: 1.5rem; line-height: 1.8; color: var(--text-secondary);">
                    Today, we pride ourselves on our attention to detail, creative approach, and the personal touch we bring 
                    to every event. Each celebration we organize is treated as if it were our own family's special moment.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Mission, Vision & Values -->
<section class="section" style="background: linear-gradient(135deg, #F9FAFB 0%, #F3F4F6 100%);">
    <div class="container">
        <div class="section-header animate-fade-up text-center">
            <p class="section-subtitle script-text">Our Foundation</p>
            <h2 class="section-title">Mission, Vision & Values</h2>
        </div>
        
        <div class="grid grid-3">
            <div class="card glass-card animate-fade-up" style="text-align: center; padding: 3rem 2rem;">
                <div style="font-size: 4rem; color: var(--primary-gold); margin-bottom: 1.5rem;">
                    <i class="fas fa-bullseye"></i>
                </div>
                <h3 style="margin-bottom: 1rem; color: var(--text-primary);">Our Mission</h3>
                <p style="color: var(--text-secondary); line-height: 1.6; margin: 0;">
                    To create unforgettable experiences that bring people together and celebrate life's most precious moments 
                    with creativity, professionalism, and heartfelt dedication.
                </p>
            </div>
            
            <div class="card glass-card animate-fade-up" style="text-align: center; padding: 3rem 2rem;">
                <div style="font-size: 4rem; color: var(--primary-purple); margin-bottom: 1.5rem;">
                    <i class="fas fa-eye"></i>
                </div>
                <h3 style="margin-bottom: 1rem; color: var(--text-primary);">Our Vision</h3>
                <p style="color: var(--text-secondary); line-height: 1.6; margin: 0;">
                    To be the leading event management company known for transforming dreams into reality and setting 
                    new standards of excellence in the celebration industry.
                </p>
            </div>
            
            <div class="card glass-card animate-fade-up" style="text-align: center; padding: 3rem 2rem;">
                <div style="font-size: 4rem; color: var(--primary-maroon); margin-bottom: 1.5rem;">
                    <i class="fas fa-heart"></i>
                </div>
                <h3 style="margin-bottom: 1rem; color: var(--text-primary);">Our Values</h3>
                <p style="color: var(--text-secondary); line-height: 1.6; margin: 0;">
                    Integrity, creativity, excellence, and genuine care for our clients. We believe in building lasting 
                    relationships through trust, transparency, and exceptional service.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Meet Our Team -->
<section class="section">
    <div class="container">
        <div class="section-header animate-fade-up text-center">
            <p class="section-subtitle script-text">Our People</p>
            <h2 class="section-title">Meet Our Expert Team</h2>
            <p class="section-description">
                Our dedicated team of professionals brings together years of experience, creativity, 
                and passion to make every event extraordinary.
            </p>
        </div>
        
        <div class="grid grid-3">
            <div class="team-member card animate-fade-up">
                <div class="team-image">
                    <img src="assets/images/team/founder.jpg" alt="Founder & CEO" 
                         data-src="assets/images/team/founder.jpg" class="lazy">
                    <div class="team-overlay">
                        <div class="team-social">
                            <a href="#" class="social-link"><i class="fab fa-linkedin"></i></a>
                            <a href="#" class="social-link"><i class="fab fa-instagram"></i></a>
                        </div>
                    </div>
                </div>
                <div class="team-info">
                    <h4>Rajesh Kumar</h4>
                    <p class="team-role">Founder & CEO</p>
                    <p class="team-description">
                        With over 10 years of experience in event management, Rajesh founded SSV with a vision 
                        to create magical experiences that touch hearts and create lasting memories.
                    </p>
                </div>
            </div>
            
            <div class="team-member card animate-fade-up">
                <div class="team-image">
                    <img src="assets/images/team/creative-director.jpg" alt="Creative Director" 
                         data-src="assets/images/team/creative-director.jpg" class="lazy">
                    <div class="team-overlay">
                        <div class="team-social">
                            <a href="#" class="social-link"><i class="fab fa-linkedin"></i></a>
                            <a href="#" class="social-link"><i class="fab fa-behance"></i></a>
                        </div>
                    </div>
                </div>
                <div class="team-info">
                    <h4>Priya Sharma</h4>
                    <p class="team-role">Creative Director</p>
                    <p class="team-description">
                        Priya brings artistic vision to life with her innovative designs and creative concepts. 
                        She ensures every event has a unique aesthetic that perfectly reflects our clients' personalities.
                    </p>
                </div>
            </div>
            
            <div class="team-member card animate-fade-up">
                <div class="team-image">
                    <img src="assets/images/team/operations-manager.jpg" alt="Operations Manager" 
                         data-src="assets/images/team/operations-manager.jpg" class="lazy">
                    <div class="team-overlay">
                        <div class="team-social">
                            <a href="#" class="social-link"><i class="fab fa-linkedin"></i></a>
                            <a href="#" class="social-link"><i class="fab fa-twitter"></i></a>
                        </div>
                    </div>
                </div>
                <div class="team-info">
                    <h4>Amit Patel</h4>
                    <p class="team-role">Operations Manager</p>
                    <p class="team-description">
                        Amit ensures flawless execution of every event with his meticulous planning and coordination skills. 
                        His attention to detail guarantees that everything runs smoothly on your special day.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Why Choose Us -->
<section class="section" style="background: var(--bg-gradient); color: white;">
    <div class="container">
        <div class="section-header animate-fade-up text-center">
            <p class="section-subtitle script-text" style="color: var(--light-gold);">What Sets Us Apart</p>
            <h2 class="section-title" style="color: white;">Why Choose Shree Shyam Vartika</h2>
        </div>
        
        <div class="grid grid-2">
            <div class="feature-list animate-fade-left">
                <div class="feature-item" style="display: flex; align-items: flex-start; gap: 1rem; margin-bottom: 2rem;">
                    <div class="feature-icon" style="width: 50px; height: 50px; background: var(--accent-gold); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; flex-shrink: 0;">
                        <i class="fas fa-award"></i>
                    </div>
                    <div>
                        <h4 style="color: white; margin-bottom: 0.5rem;">Award-Winning Excellence</h4>
                        <p style="color: rgba(255,255,255,0.9); margin: 0;">
                            Recognized for outstanding service quality and creativity in event management industry.
                        </p>
                    </div>
                </div>
                
                <div class="feature-item" style="display: flex; align-items: flex-start; gap: 1rem; margin-bottom: 2rem;">
                    <div class="feature-icon" style="width: 50px; height: 50px; background: var(--accent-gold); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; flex-shrink: 0;">
                        <i class="fas fa-users"></i>
                    </div>
                    <div>
                        <h4 style="color: white; margin-bottom: 0.5rem;">Professional Team</h4>
                        <p style="color: rgba(255,255,255,0.9); margin: 0;">
                            Experienced professionals dedicated to making your event perfect down to the smallest detail.
                        </p>
                    </div>
                </div>
                
                <div class="feature-item" style="display: flex; align-items: flex-start; gap: 1rem; margin-bottom: 2rem;">
                    <div class="feature-icon" style="width: 50px; height: 50px; background: var(--accent-gold); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; flex-shrink: 0;">
                        <i class="fas fa-palette"></i>
                    </div>
                    <div>
                        <h4 style="color: white; margin-bottom: 0.5rem;">Creative Innovation</h4>
                        <p style="color: rgba(255,255,255,0.9); margin: 0;">
                            Unique and personalized concepts that reflect your style and create unforgettable experiences.
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="feature-list animate-fade-right">
                <div class="feature-item" style="display: flex; align-items: flex-start; gap: 1rem; margin-bottom: 2rem;">
                    <div class="feature-icon" style="width: 50px; height: 50px; background: var(--accent-gold); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; flex-shrink: 0;">
                        <i class="fas fa-handshake"></i>
                    </div>
                    <div>
                        <h4 style="color: white; margin-bottom: 0.5rem;">Transparent Pricing</h4>
                        <p style="color: rgba(255,255,255,0.9); margin: 0;">
                            No hidden costs or surprise charges. Clear, upfront pricing with detailed breakdowns.
                        </p>
                    </div>
                </div>
                
                <div class="feature-item" style="display: flex; align-items: flex-start; gap: 1rem; margin-bottom: 2rem;">
                    <div class="feature-icon" style="width: 50px; height: 50px; background: var(--accent-gold); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; flex-shrink: 0;">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div>
                        <h4 style="color: white; margin-bottom: 0.5rem;">24/7 Support</h4>
                        <p style="color: rgba(255,255,255,0.9); margin: 0;">
                            Round-the-clock assistance during your event planning journey and on the event day.
                        </p>
                    </div>
                </div>
                
                <div class="feature-item" style="display: flex; align-items: flex-start; gap: 1rem; margin-bottom: 2rem;">
                    <div class="feature-icon" style="width: 50px; height: 50px; background: var(--accent-gold); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; flex-shrink: 0;">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <div>
                        <h4 style="color: white; margin-bottom: 0.5rem;">100% Guarantee</h4>
                        <p style="color: rgba(255,255,255,0.9); margin: 0;">
                            Complete satisfaction guarantee with backup plans and contingency measures for every event.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Achievements & Milestones -->
<section class="section">
    <div class="container">
        <div class="section-header animate-fade-up text-center">
            <p class="section-subtitle script-text">Our Achievements</p>
            <h2 class="section-title">Milestones & Recognition</h2>
        </div>
        
        <div class="timeline">
            <div class="timeline-item animate-fade-left">
                <div class="timeline-year">2015</div>
                <div class="timeline-content">
                    <h4>Company Founded</h4>
                    <p>Started Shree Shyam Vartika with a small team and big dreams in the event management industry.</p>
                </div>
            </div>
            
            <div class="timeline-item animate-fade-right">
                <div class="timeline-year">2017</div>
                <div class="timeline-content">
                    <h4>100th Event Milestone</h4>
                    <p>Successfully completed our 100th event, marking a significant milestone in our journey.</p>
                </div>
            </div>
            
            <div class="timeline-item animate-fade-left">
                <div class="timeline-year">2019</div>
                <div class="timeline-content">
                    <h4>Industry Recognition</h4>
                    <p>Received "Best Event Management Company" award from the Regional Business Association.</p>
                </div>
            </div>
            
            <div class="timeline-item animate-fade-right">
                <div class="timeline-year">2021</div>
                <div class="timeline-content">
                    <h4>Team Expansion</h4>
                    <p>Expanded our team to 15+ professionals including specialized decorators, coordinators, and photographers.</p>
                </div>
            </div>
            
            <div class="timeline-item animate-fade-left">
                <div class="timeline-year">2023</div>
                <div class="timeline-content">
                    <h4>500+ Events Completed</h4>
                    <p>Celebrated organizing over 500 successful events with a 100% client satisfaction rate.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="section" style="background: linear-gradient(135deg, #F9FAFB 0%, #F3F4F6 100%);">
    <div class="container">
        <div class="text-center animate-fade-up">
            <h2 class="section-title">Ready to Create Your Perfect Event?</h2>
            <p style="font-size: 1.2rem; margin-bottom: 2rem; color: var(--text-secondary);">
                Let our experienced team help you plan an unforgettable celebration. Contact us today for a free consultation.
            </p>
            <div style="display: flex; justify-content: center; gap: 1rem; flex-wrap: wrap;">
                <a href="contact.php" class="btn btn-primary btn-lg">
                    <i class="fas fa-envelope"></i>
                    Get Free Consultation
                </a>
                <a href="services.php" class="btn btn-outline btn-lg">
                    <i class="fas fa-concierge-bell"></i>
                    Explore Services
                </a>
            </div>
        </div>
    </div>
</section>

<style>
/* About page specific styles */
.text-center { text-align: center; }

.hero-stats {
    display: flex;
    gap: 2rem;
}

.stat-item {
    text-align: center;
}

.team-member {
    overflow: hidden;
    transition: var(--transition-normal);
}

.team-member:hover {
    transform: translateY(-5px);
    box-shadow: var(--shadow-xl);
}

.team-image {
    position: relative;
    aspect-ratio: 4/5;
    overflow: hidden;
}

.team-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: var(--transition-slow);
}

.team-member:hover .team-image img {
    transform: scale(1.1);
}

.team-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(107, 70, 193, 0.8);
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: var(--transition-normal);
}

.team-member:hover .team-overlay {
    opacity: 1;
}

.team-social {
    display: flex;
    gap: 1rem;
}

.social-link {
    width: 40px;
    height: 40px;
    background: var(--accent-gold);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    transition: var(--transition-normal);
}

.social-link:hover {
    background: white;
    color: var(--primary-purple);
    transform: scale(1.1);
}

.team-info {
    padding: 2rem;
    text-align: center;
}

.team-info h4 {
    font-family: var(--font-heading);
    font-size: 1.3rem;
    margin-bottom: 0.5rem;
    color: var(--text-primary);
}

.team-role {
    color: var(--primary-gold);
    font-weight: 600;
    margin-bottom: 1rem;
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.team-description {
    color: var(--text-secondary);
    line-height: 1.6;
    font-size: 0.9rem;
}

.timeline {
    position: relative;
    max-width: 800px;
    margin: 0 auto;
    padding: 2rem 0;
}

.timeline::before {
    content: '';
    position: absolute;
    left: 50%;
    transform: translateX(-50%);
    width: 2px;
    height: 100%;
    background: var(--primary-gold);
}

.timeline-item {
    position: relative;
    margin-bottom: 3rem;
    display: flex;
    align-items: center;
    gap: 2rem;
}

.timeline-item:nth-child(even) {
    flex-direction: row-reverse;
}

.timeline-year {
    width: 100px;
    height: 100px;
    background: var(--primary-purple);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 700;
    font-size: 1.1rem;
    box-shadow: var(--shadow-lg);
    flex-shrink: 0;
    position: relative;
    z-index: 2;
}

.timeline-content {
    flex: 1;
    background: var(--glass-white);
    backdrop-filter: var(--backdrop-blur);
    border: 1px solid var(--glass-border);
    border-radius: var(--radius-lg);
    padding: 2rem;
    box-shadow: var(--shadow-md);
}

.timeline-content h4 {
    font-family: var(--font-heading);
    color: var(--text-primary);
    margin-bottom: 1rem;
    font-size: 1.3rem;
}

.timeline-content p {
    color: var(--text-secondary);
    margin: 0;
    line-height: 1.6;
}

@media (max-width: 768px) {
    .hero-stats {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
    }
    
    .timeline::before {
        left: 30px;
    }
    
    .timeline-item {
        flex-direction: row !important;
        margin-left: 60px;
    }
    
    .timeline-item:nth-child(even) {
        flex-direction: row !important;
    }
    
    .timeline-year {
        width: 60px;
        height: 60px;
        font-size: 0.9rem;
        position: absolute;
        left: -90px;
    }
    
    .timeline-content {
        padding: 1.5rem;
    }
    
    .team-info {
        padding: 1.5rem;
    }
    
    .feature-item {
        margin-bottom: 1.5rem !important;
    }
}

@media (max-width: 480px) {
    .timeline-item {
        margin-left: 40px;
    }
    
    .timeline-year {
        width: 50px;
        height: 50px;
        font-size: 0.8rem;
        left: -70px;
    }
}
</style>

<?php
// Create placeholder team images
$team_images = ['founder.jpg', 'creative-director.jpg', 'operations-manager.jpg', 'our-story.jpg'];
foreach ($team_images as $img) {
    $dir = $img === 'our-story.jpg' ? 'assets/images/' : 'assets/images/team/';
    if (!file_exists('public/' . $dir)) {
        mkdir('public/' . $dir, 0755, true);
    }
    if (!file_exists('public/' . $dir . $img)) {
        file_put_contents('public/' . $dir . $img, "# Placeholder for $img");
    }
}

include '../includes/footer.php'; 
?>