<?php
/**
 * Database Configuration for SSV Website
 * Shree Shyam Vartika Event Management
 */

// Database configuration constants
define('DB_HOST', 'localhost');
define('DB_NAME', 'ssv_website');
define('DB_USER', 'root');
define('DB_PASS', '');

// Database connection class
class Database {
    private static $instance = null;
    private $connection;
    
    private function __construct() {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
            $this->connection = new PDO($dsn, DB_USER, DB_PASS);
            $this->connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->connection->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        } catch(PDOException $e) {
            die("Database connection failed: " . $e->getMessage());
        }
    }
    
    public static function getInstance() {
        if (self::$instance == null) {
            self::$instance = new Database();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        return $this->connection;
    }
    
    // Prevent cloning
    private function __clone() {}
    
    // Prevent unserialization
    public function __wakeup() {}
}

// Helper function to get database connection
function getDB() {
    return Database::getInstance()->getConnection();
}

// Test connection on first load (only if we're not creating the database)
if (!defined('SKIP_DB_TEST')) {
    try {
        $db = getDB();
        // Connection successful
    } catch(Exception $e) {
        // Database might not exist yet - that's ok for initial setup
        error_log("Database connection info: " . $e->getMessage());
    }
}
?>