# SSV Website - Shree Shyam Vartika Event Management

A modern, responsive event management website built with PHP, MySQL, HTML, CSS, and JavaScript. Features glassmorphic design with royal wedding theme colors and comprehensive functionality for showcasing event services.

## Features

- **Modern Glassmorphic Design** - Royal purple, maroon, and gold color scheme
- **Responsive Layout** - Mobile, tablet, and desktop friendly
- **Event Services Showcase** - Wedding, engagement, birthday, corporate events
- **Interactive Gallery** - Image and video lightbox with filtering
- **Contact Form** - Lead capture with database storage
- **Admin Panel** - Complete content management system
- **SEO Optimized** - Clean URLs, meta tags, and semantic HTML
- **Security Features** - Protected admin area, input validation, XSS protection

## Project Structure

```
SSV-Website/
├── public/                  # User-facing website files
│   ├── index.php           # Home page
│   ├── services.php        # Services page
│   ├── gallery.php         # Gallery page
│   ├── contact.php         # Contact page
│   ├── about.php           # About page
│   └── assets/             # Static assets (CSS, JS, images)
├── admin/                  # Admin panel
├── config/                 # Configuration files
│   └── db.php             # Database connection
├── includes/               # Reusable components
│   ├── header.php
│   ├── footer.php
│   └── navbar.php
├── uploads/               # Media uploads
└── .htaccess             # Apache configuration
```

## Installation

### Prerequisites

- XAMPP (or any LAMP/WAMP stack)
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache web server

### Setup Instructions

1. **Install XAMPP**
   - Download and install XAMPP from [https://www.apachefriends.org/](https://www.apachefriends.org/)
   - Start Apache and MySQL services

2. **Clone/Extract Project**
   ```bash
   # Extract the project to xampp/htdocs/SSV/
   # Or clone from repository
   ```

3. **Database Setup**
   - Open phpMyAdmin (http://localhost/phpmyadmin)
   - Create a new database named `ssv_website`
   - Import the database schema:
     ```sql
     # Run the SQL commands from database_schema.sql
     ```
   - Or execute the file directly in phpMyAdmin

4. **Configure Database Connection**
   - Open `config/db.php`
   - Update database credentials if needed:
     ```php
     define('DB_HOST', 'localhost');
     define('DB_NAME', 'ssv_website');
     define('DB_USER', 'root');
     define('DB_PASS', '');
     ```

5. **Set Permissions**
   - Ensure `uploads/` directory is writable
   ```bash
   chmod 755 uploads/
   chmod 755 uploads/services/
   chmod 755 uploads/gallery/
   chmod 755 uploads/testimonials/
   ```

6. **Access the Website**
   - Open browser and go to: `http://localhost/SSV`
   - Admin panel: `http://localhost/SSV/admin`
   - Default admin credentials:
     - Username: `admin`
     - Password: `admin123`

## Configuration

### Business Settings

Update business information in the database `business_settings` table or through the admin panel:

- Business name and tagline
- Contact information (phone, email, address)
- Social media links
- Google Maps embed code

### Customization

#### Colors and Theme
- Edit `public/assets/css/style.css`
- Modify CSS variables in the `:root` section
- Update color scheme, fonts, and spacing

#### Content
- Add/edit services through admin panel
- Upload gallery images and videos
- Manage testimonials and client reviews
- Update business information and contact details

## Usage

### Public Website

1. **Home Page** - Hero section, featured services, gallery preview, testimonials
2. **Services** - Complete list of event management services
3. **Gallery** - Filterable image and video gallery with lightbox
4. **Contact** - Contact form, business info, Google Maps integration
5. **About** - Company information, team, and achievements

### Admin Panel

1. **Dashboard** - Overview of enquiries and statistics
2. **Manage Services** - Add/edit/delete event services
3. **Manage Gallery** - Upload and organize photos/videos
4. **Manage Testimonials** - Client reviews and ratings
5. **Manage Enquiries** - Contact form submissions
6. **Settings** - Business information and configuration

## Security Features

- Input validation and sanitization
- SQL injection prevention with prepared statements
- XSS protection with htmlspecialchars()
- CSRF protection for admin forms
- File upload security with type validation
- Admin area access control
- Secure password hashing

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Internet Explorer 11+ (limited support)

## Mobile Responsiveness

The website is fully responsive and optimized for:
- Mobile devices (320px - 768px)
- Tablets (768px - 1024px)
- Desktops (1024px+)

## Performance Features

- CSS and JavaScript minification
- Image optimization recommendations
- Lazy loading for images
- Browser caching headers
- GZIP compression enabled

## SEO Features

- Clean, semantic HTML structure
- Proper heading hierarchy (H1, H2, H3, etc.)
- Meta tags for title, description, keywords
- Open Graph tags for social sharing
- Schema markup for business information
- Clean URL structure
- XML sitemap ready

## Troubleshooting

### Common Issues

1. **Database Connection Error**
   - Check MySQL service is running
   - Verify database credentials in `config/db.php`
   - Ensure database `ssv_website` exists

2. **Images Not Loading**
   - Check file permissions on `uploads/` directory
   - Verify image paths in database
   - Ensure Apache has read access to files

3. **Admin Panel Not Accessible**
   - Clear browser cache and cookies
   - Check `.htaccess` file is present
   - Verify admin user exists in database

4. **Contact Form Not Working**
   - Check database connection
   - Verify form action URL
   - Check Apache error logs

### Error Logs

- Check Apache error logs: `xampp/apache/logs/error.log`
- Check PHP error logs in the same directory
- Enable PHP error reporting in development:
  ```php
  error_reporting(E_ALL);
  ini_set('display_errors', 1);
  ```

## Development

### Adding New Features

1. **New Page**
   - Create PHP file in `public/` directory
   - Include header and footer from `includes/`
   - Add navigation link in `includes/header.php`

2. **New Admin Feature**
   - Create PHP file in `admin/` directory
   - Add database table if needed
   - Include admin authentication check
   - Add navigation link in admin dashboard

3. **Database Changes**
   - Update `database_schema.sql`
   - Create migration script if needed
   - Update relevant PHP files

## Support

For support and customization:

- Email: support@shreeshyamvartika.com
- Phone: +91-9876543210
- WhatsApp: Available 24/7

## License

This project is proprietary software developed for Shree Shyam Vartika Event Management.

## Version History

- **v1.0.0** - Initial release with core functionality
- **v1.1.0** - Added admin panel and content management
- **v1.2.0** - Enhanced security and SEO features

---

**Built with ❤️ for creating unforgettable events**